#!/bin/sh
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

BIN_SERVICE_TOOL="/usr/syno/bin/servicetool"
BIN_BASENAME="/usr/bin/basename"
BIN_DIRNAME="/usr/bin/dirname"

PATH_ALIVE_VOLUME=""
PATH_ROTATE_FILE=${1}

# 1. Check if compression is failed or not
if [ ! -f "${PATH_ROTATE_FILE}" ]; then
	return
fi

# 2. Find available data volume
PATH_ALIVE_VOLUME=`${BIN_SERVICE_TOOL} --get-alive-volume`
if [ -z "${PATH_ALIVE_VOLUME}" ]; then
	logger -p 0 "Remove debug log ${PATH_ROTATE_FILE} due to no available data volume"
	unlink ${PATH_ROTATE_FILE}
	return
fi

# 3. Move log file to data volume
FILE_ROTATE_FILE=`${BIN_BASENAME} ${PATH_ROTATE_FILE}`
DIR_ROTATE_FILE=`${BIN_DIRNAME} ${PATH_ROTATE_FILE}`
mv ${PATH_ROTATE_FILE} ${PATH_ALIVE_VOLUME}/@tmp/
if [ 0 != $? ]; then
	logger -p 0 "Remove debug log ${PATH_ROTATE_FILE} due to data volume is too small"
	unlink ${PATH_ROTATE_FILE}
	return
fi

# 4. Compress log file to system partition
xz -z -3 ${PATH_ALIVE_VOLUME}/@tmp/${FILE_ROTATE_FILE}
mv ${PATH_ALIVE_VOLUME}/@tmp/${FILE_ROTATE_FILE}.xz ${DIR_ROTATE_FILE}

